/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class ArrayType
extends BaseNode {
    private final BaseNode base;
    private BaseNode dimensionExpression;
    private String dimensionString;

    public ArrayType(BaseNode base) {
        super(NodeType.ArrayType);
        this.base = base;
        this.dimensionExpression = null;
    }

    public ArrayType(BaseNode base, BaseNode dimensionExpression) {
        super(NodeType.ArrayType);
        this.base = base;
        this.dimensionExpression = dimensionExpression;
    }

    public ArrayType(BaseNode base, String dimensionString) {
        super(NodeType.ArrayType);
        this.base = base;
        this.dimensionString = dimensionString;
    }

    @Override
    public boolean hasRightPart() {
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void printLeft(StringWriter writer) {
        this.base.printLeft(writer);
    }

    @Override
    public void printRight(StringWriter writer) {
        writer.write(" ");
        writer.write("[");
        if (this.dimensionString != null) {
            writer.write(this.dimensionString);
        } else if (this.dimensionExpression != null) {
            this.dimensionExpression.print(writer);
        }
        writer.write("]");
        this.base.printRight(writer);
    }
}

