/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class EncodedFunction
extends BaseNode {
    private final BaseNode name;
    private final BaseNode params;
    private final BaseNode cv;
    private final BaseNode ref;
    private final BaseNode attrs;
    private final BaseNode ret;

    public EncodedFunction(BaseNode name, BaseNode params, BaseNode cv, BaseNode ref, BaseNode attrs, BaseNode ret) {
        super(NodeType.NameType);
        this.name = name;
        this.params = params;
        this.cv = cv;
        this.ref = ref;
        this.attrs = attrs;
        this.ret = ret;
    }

    @Override
    public void printLeft(StringWriter writer) {
        if (this.ret != null) {
            this.ret.printLeft(writer);
            if (!this.ret.hasRightPart()) {
                writer.write(" ");
            }
        }
        this.name.print(writer);
    }

    @Override
    public boolean hasRightPart() {
        return true;
    }

    @Override
    public void printRight(StringWriter writer) {
        writer.write("(");
        if (this.params != null) {
            this.params.print(writer);
        }
        writer.write(")");
        if (this.ret != null) {
            this.ret.printRight(writer);
        }
        if (this.cv != null) {
            this.cv.print(writer);
        }
        if (this.ref != null) {
            this.ref.print(writer);
        }
        if (this.attrs != null) {
            this.attrs.print(writer);
        }
    }
}

