/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class SpecialSubstitution
extends BaseNode {
    private final SpecialType specialSubstitutionKey;

    public SpecialSubstitution(SpecialType specialSubstitutionKey) {
        super(NodeType.SpecialSubstitution);
        this.specialSubstitutionKey = specialSubstitutionKey;
    }

    public void SetExtended() {
        this.type = NodeType.ExpandedSpecialSubstitution;
    }

    @Override
    String getName() {
        switch (this.specialSubstitutionKey) {
            case Allocator: {
                return "allocator";
            }
            case BasicString: {
                return "basic_string";
            }
            case String: {
                if (this.type == NodeType.ExpandedSpecialSubstitution) {
                    return "basic_string";
                }
                return "string";
            }
            case IStream: {
                return "istream";
            }
            case OStream: {
                return "ostream";
            }
            case IOStream: {
                return "iostream";
            }
        }
        return null;
    }

    private String GetExtendedName() {
        switch (this.specialSubstitutionKey) {
            case Allocator: {
                return "std::allocator";
            }
            case BasicString: {
                return "std::basic_string";
            }
            case String: {
                return "std::basic_string<char, std::char_traits<char>, std::allocator<char> >";
            }
            case IStream: {
                return "std::basic_istream<char, std::char_traits<char> >";
            }
            case OStream: {
                return "std::basic_ostream<char, std::char_traits<char> >";
            }
            case IOStream: {
                return "std::basic_iostream<char, std::char_traits<char> >";
            }
        }
        return "";
    }

    @Override
    public void printLeft(StringWriter writer) {
        if (this.type == NodeType.ExpandedSpecialSubstitution) {
            writer.write(this.GetExtendedName());
        } else {
            writer.write("std::");
            writer.write(this.getName());
        }
    }

    public static enum SpecialType {
        Allocator,
        BasicString,
        String,
        IStream,
        OStream,
        IOStream;

    }
}

