/*
 * Decompiled with CFR 0.152.
 */
package capstone;

import capstone.Capstone;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.Arrays;
import java.util.List;

public class Arm {

    public static class OpInfo
    implements capstone.api.arm.OpInfo {
        public final boolean usermode;
        public final int vectorSize;
        public final int vectorData;
        public final int cpsMode;
        public final int cpsFlag;
        public final int cc;
        public final boolean updateFlags;
        public final boolean writeback;
        public final int memBarrier;
        public final Operand[] operands;

        public OpInfo(UnionOpInfo op_info) {
            this.usermode = op_info.usermode;
            this.vectorSize = op_info.vector_size;
            this.vectorData = op_info.vector_data;
            this.cpsMode = op_info.cps_mode;
            this.cpsFlag = op_info.cps_flag;
            this.cc = op_info.cc;
            this.updateFlags = op_info.update_flags > 0;
            this.writeback = op_info.writeback > 0;
            this.memBarrier = op_info.mem_barrier;
            this.operands = op_info.op;
        }

        @Override
        public boolean isWriteBack() {
            return this.writeback;
        }

        public Operand[] getOperands() {
            return this.operands;
        }

        @Override
        public boolean isUpdateFlags() {
            return this.updateFlags;
        }

        @Override
        public int getCpsMode() {
            return this.cpsMode;
        }

        @Override
        public int getCpsFlag() {
            return this.cpsFlag;
        }

        @Override
        public int getVectorData() {
            return this.vectorData;
        }

        @Override
        public int getVectorSize() {
            return this.vectorSize;
        }

        @Override
        public boolean isUserMode() {
            return this.usermode;
        }

        @Override
        public int getCodeCondition() {
            return this.cc;
        }
    }

    public static class UnionOpInfo
    extends Capstone.UnionOpInfo {
        public boolean usermode;
        public int vector_size;
        public int vector_data;
        public int cps_mode;
        public int cps_flag;
        public int cc;
        public byte update_flags;
        public byte writeback;
        public int mem_barrier;
        public byte op_count;
        public Operand[] op = new Operand[36];

        public void read() {
            this.readField("usermode");
            this.readField("vector_size");
            this.readField("vector_data");
            this.readField("cps_mode");
            this.readField("cps_flag");
            this.readField("cc");
            this.readField("update_flags");
            this.readField("writeback");
            this.readField("mem_barrier");
            this.readField("op_count");
            this.op = new Operand[this.op_count];
            if (this.op_count != 0) {
                this.readField("op");
            }
        }

        public List getFieldOrder() {
            return Arrays.asList("usermode", "vector_size", "vector_data", "cps_mode", "cps_flag", "cc", "update_flags", "writeback", "mem_barrier", "op_count", "op");
        }
    }

    public static class Operand
    extends Structure
    implements capstone.api.arm.Operand {
        public int vector_index;
        public OpShift shift;
        public int type;
        public OpValue value;
        public boolean subtracted;
        public byte access;
        public byte neon_lane;

        public void read() {
            this.readField("vector_index");
            this.readField("type");
            if (this.type == 3) {
                this.value.setType(MemType.class);
            }
            if (this.type == 4) {
                this.value.setType(Double.TYPE);
            }
            if (this.type == 65 || this.type == 2 || this.type == 64) {
                this.value.setType(Integer.TYPE);
            }
            if (this.type == 1) {
                this.value.setType(Integer.TYPE);
            }
            if (this.type == 0) {
                return;
            }
            this.readField("value");
            this.readField("shift");
            this.readField("subtracted");
            this.readField("access");
            this.readField("neon_lane");
        }

        public List<String> getFieldOrder() {
            return Arrays.asList("vector_index", "shift", "type", "value", "subtracted", "access", "neon_lane");
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OpValue getValue() {
            return this.value;
        }

        @Override
        public int getVectorIndex() {
            return this.vector_index;
        }

        @Override
        public boolean isSubtracted() {
            return this.subtracted;
        }

        @Override
        public OpShift getShift() {
            return this.shift;
        }
    }

    public static class OpShift
    extends Structure
    implements capstone.api.OpShift {
        public int type;
        public int value;

        public List<String> getFieldOrder() {
            return Arrays.asList("type", "value");
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static class OpValue
    extends Union
    implements capstone.api.arm.OpValue {
        public int reg;
        public int imm;
        public double fp;
        public MemType mem;
        public int setend;

        public List<String> getFieldOrder() {
            return Arrays.asList("reg", "imm", "fp", "mem", "setend");
        }

        @Override
        public int getReg() {
            return this.reg;
        }

        @Override
        public int getImm() {
            return this.imm;
        }

        @Override
        public int getSetEnd() {
            return this.setend;
        }

        @Override
        public double getFp() {
            return this.fp;
        }

        @Override
        public MemType getMem() {
            return this.mem;
        }
    }

    public static class MemType
    extends Structure
    implements capstone.api.arm.MemType {
        public int base;
        public int index;
        public int scale;
        public int disp;
        public int lshift;

        public List<String> getFieldOrder() {
            return Arrays.asList("base", "index", "scale", "disp", "lshift");
        }

        @Override
        public int getBase() {
            return this.base;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        @Override
        public int getDisp() {
            return this.disp;
        }

        @Override
        public int getLshift() {
            return this.lshift;
        }
    }
}

