/*
 * Decompiled with CFR 0.152.
 */
package capstone;

import capstone.Arm;
import capstone.Arm64;
import capstone.M680x;
import capstone.Mips;
import capstone.Ppc;
import capstone.Sparc;
import capstone.Systemz;
import capstone.X86;
import capstone.Xcore;
import capstone.api.Disassembler;
import capstone.api.Instruction;
import capstone.api.RegsAccess;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class Capstone
implements Disassembler {
    public static final int CS_API_MAJOR = 4;
    public static final int CS_API_MINOR = 0;
    public static final int CS_ARCH_ARM = 0;
    public static final int CS_ARCH_ARM64 = 1;
    public static final int CS_ARCH_MIPS = 2;
    public static final int CS_ARCH_X86 = 3;
    public static final int CS_ARCH_PPC = 4;
    public static final int CS_ARCH_SPARC = 5;
    public static final int CS_ARCH_SYSZ = 6;
    public static final int CS_ARCH_XCORE = 7;
    public static final int CS_ARCH_M68K = 8;
    public static final int CS_ARCH_TMS320C64X = 9;
    public static final int CS_ARCH_M680X = 10;
    public static final int CS_ARCH_MAX = 11;
    public static final int CS_ARCH_ALL = 65535;
    public static final int CS_MODE_LITTLE_ENDIAN = 0;
    public static final int CS_MODE_ARM = 0;
    public static final int CS_MODE_16 = 2;
    public static final int CS_MODE_32 = 4;
    public static final int CS_MODE_64 = 8;
    public static final int CS_MODE_THUMB = 16;
    public static final int CS_MODE_MCLASS = 32;
    public static final int CS_MODE_V8 = 64;
    public static final int CS_MODE_MICRO = 16;
    public static final int CS_MODE_MIPS3 = 32;
    public static final int CS_MODE_MIPS32R6 = 64;
    public static final int CS_MODE_MIPS2 = 128;
    public static final int CS_MODE_BIG_ENDIAN = Integer.MIN_VALUE;
    public static final int CS_MODE_V9 = 16;
    public static final int CS_MODE_MIPS32 = 4;
    public static final int CS_MODE_MIPS64 = 8;
    public static final int CS_MODE_QPX = 16;
    public static final int CS_MODE_M680X_6301 = 2;
    public static final int CS_MODE_M680X_6309 = 4;
    public static final int CS_MODE_M680X_6800 = 8;
    public static final int CS_MODE_M680X_6801 = 16;
    public static final int CS_MODE_M680X_6805 = 32;
    public static final int CS_MODE_M680X_6808 = 64;
    public static final int CS_MODE_M680X_6809 = 128;
    public static final int CS_MODE_M680X_6811 = 256;
    public static final int CS_MODE_M680X_CPU12 = 512;
    public static final int CS_MODE_M680X_HCS08 = 1024;
    public static final int CS_ERR_OK = 0;
    public static final int CS_ERR_MEM = 1;
    public static final int CS_ERR_ARCH = 2;
    public static final int CS_ERR_HANDLE = 3;
    public static final int CS_ERR_CSH = 4;
    public static final int CS_ERR_MODE = 5;
    public static final int CS_ERR_OPTION = 6;
    public static final int CS_ERR_DETAIL = 7;
    public static final int CS_ERR_MEMSETUP = 8;
    public static final int CS_ERR_VERSION = 9;
    public static final int CS_ERR_DIET = 10;
    public static final int CS_ERR_SKIPDATA = 11;
    public static final int CS_ERR_X86_ATT = 12;
    public static final int CS_ERR_X86_INTEL = 13;
    public static final int CS_OPT_SYNTAX = 1;
    public static final int CS_OPT_DETAIL = 2;
    public static final int CS_OPT_MODE = 3;
    public static final int CS_OPT_OFF = 0;
    public static final int CS_OPT_SYNTAX_INTEL = 1;
    public static final int CS_OPT_SYNTAX_ATT = 2;
    public static final int CS_OPT_ON = 3;
    public static final int CS_OPT_SYNTAX_NOREGNAME = 3;
    public static final int CS_OP_INVALID = 0;
    public static final int CS_OP_REG = 1;
    public static final int CS_OP_IMM = 2;
    public static final int CS_OP_MEM = 3;
    public static final int CS_OP_FP = 4;
    public static final int CS_AC_INVALID = 0;
    public static final int CS_AC_READ = 1;
    public static final int CS_AC_WRITE = 2;
    public static final int CS_GRP_INVALID = 0;
    public static final int CS_GRP_JUMP = 1;
    public static final int CS_GRP_CALL = 2;
    public static final int CS_GRP_RET = 3;
    public static final int CS_GRP_INT = 4;
    public static final int CS_GRP_IRET = 5;
    public static final int CS_GRP_PRIVILEGE = 6;
    public static final int CS_SUPPORT_DIET = 65536;
    public static final int CS_SUPPORT_X86_REDUCE = 65537;
    private static final CsInsn[] EMPTY_INSN = new CsInsn[0];
    protected NativeStruct ns;
    private static final CS cs;
    public int arch;
    public int mode;
    private int syntax;
    private int detail;
    private final boolean diet;

    private CsInsn[] fromArrayRaw(_cs_insn[] arr_raw, CsInsnDeallocator deallocator) {
        CsInsn[] arr = new CsInsn[arr_raw.length];
        for (int i = 0; i < arr_raw.length; ++i) {
            arr[i] = new CsInsn(arr_raw[i], this.arch, this.ns.csh, cs, this.diet, deallocator);
        }
        return arr;
    }

    public Capstone(int arch, int mode) {
        int coreVersion = cs.cs_version(null, null);
        int bindingVersion = 1024;
        if (coreVersion != bindingVersion) {
            throw new RuntimeException("Different API version between core " + coreVersion + " & binding " + bindingVersion + " (CS_ERR_VERSION)");
        }
        this.arch = arch;
        this.mode = mode;
        this.ns = new NativeStruct();
        this.ns.handleRef = new PointerByReference();
        if (cs.cs_open(arch, mode, this.ns.handleRef) != 0) {
            throw new RuntimeException("ERROR: Wrong arch or mode");
        }
        this.ns.csh = this.ns.handleRef.getValue();
        this.detail = 0;
        this.diet = cs.cs_support(65536);
    }

    public int version() {
        return cs.cs_version(null, null);
    }

    public void setSyntax(int syntax) {
        if (cs.cs_option(this.ns.csh, 1, new NativeLong((long)syntax)) != 0) {
            throw new RuntimeException("ERROR: Failed to set assembly syntax");
        }
        this.syntax = syntax;
    }

    @Override
    public void setDetail(boolean on) {
        int opt;
        int n = opt = on ? 3 : 0;
        if (cs.cs_option(this.ns.csh, 2, new NativeLong((long)opt)) != 0) {
            throw new RuntimeException("ERROR: Failed to set detail option");
        }
        this.detail = opt;
    }

    public void setMode(int opt) {
        if (cs.cs_option(this.ns.csh, 3, new NativeLong((long)opt)) != 0) {
            throw new RuntimeException("ERROR: Failed to set mode option");
        }
        this.mode = opt;
    }

    protected void finalize() {
    }

    @Override
    public void close() {
        cs.cs_close(this.ns.handleRef);
    }

    @Override
    public Instruction[] disasm(byte[] code, long address) {
        return this.disasm(code, address, 0L);
    }

    @Override
    public Instruction[] disasm(byte[] code, long address, long count) {
        PointerByReference insnRef = new PointerByReference();
        NativeLong c = cs.cs_disasm(this.ns.csh, code, new NativeLong((long)code.length), address, new NativeLong(count), insnRef);
        if (0 == c.intValue()) {
            return EMPTY_INSN;
        }
        Pointer p = insnRef.getValue();
        _cs_insn byref = new _cs_insn(p);
        CsInsnDeallocator deallocator = new CsInsnDeallocator(cs, p, c);
        return this.fromArrayRaw((_cs_insn[])byref.toArray(c.intValue()), deallocator);
    }

    public String strerror(int code) {
        return cs.cs_strerror(code);
    }

    static {
        try {
            File embedded = Native.extractFromResourcePath((String)"capstone", (ClassLoader)Capstone.class.getClassLoader());
            cs = (CS)Native.loadLibrary((String)embedded.getAbsolutePath(), CS.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("load capstone library failed.", e);
        }
    }

    private static class CsInsnDeallocator {
        private final CS cs;
        private final Pointer p;
        private final NativeLong c;

        CsInsnDeallocator(CS cs, Pointer p, NativeLong c) {
            this.cs = cs;
            this.p = p;
            this.c = c;
        }

        protected void finalize() {
            this.cs.cs_free(this.p, this.c);
        }
    }

    protected static class NativeStruct {
        private Pointer csh;
        private PointerByReference handleRef;

        protected NativeStruct() {
        }
    }

    private static interface CS
    extends Library {
        public int cs_open(int var1, int var2, PointerByReference var3);

        public NativeLong cs_disasm(Pointer var1, byte[] var2, NativeLong var3, long var4, NativeLong var6, PointerByReference var7);

        public void cs_free(Pointer var1, NativeLong var2);

        public int cs_close(PointerByReference var1);

        public int cs_option(Pointer var1, int var2, NativeLong var3);

        public String cs_reg_name(Pointer var1, int var2);

        public int cs_op_count(Pointer var1, Pointer var2, int var3);

        public int cs_op_index(Pointer var1, Pointer var2, int var3, int var4);

        public String cs_insn_name(Pointer var1, int var2);

        public String cs_group_name(Pointer var1, int var2);

        public byte cs_insn_group(Pointer var1, Pointer var2, int var3);

        public byte cs_reg_read(Pointer var1, Pointer var2, int var3);

        public byte cs_reg_write(Pointer var1, Pointer var2, int var3);

        public int cs_errno(Pointer var1);

        public int cs_version(IntByReference var1, IntByReference var2);

        public boolean cs_support(int var1);

        public String cs_strerror(int var1);

        public int cs_regs_access(Pointer var1, Pointer var2, Pointer var3, ByteByReference var4, Pointer var5, ByteByReference var6);
    }

    public static class CsRegsAccess
    implements RegsAccess {
        public final short[] regsRead;
        public final short[] regsWrite;

        public CsRegsAccess(short[] regsRead, short[] regsWrite) {
            this.regsRead = regsRead;
            this.regsWrite = regsWrite;
        }

        @Override
        public short[] getRegsRead() {
            return this.regsRead;
        }

        @Override
        public short[] getRegsWrite() {
            return this.regsWrite;
        }
    }

    public static class CsInsn
    extends Instruction {
        private final Pointer csh;
        private final CS cs;
        private final _cs_insn raw;
        private final int arch;
        public int id;
        private final long address;
        public short size;
        public byte[] bytes;
        public String mnemonic;
        public String opStr;
        public short[] regsRead;
        public short[] regsWrite;
        public byte[] groups;
        public OpInfo operands;
        private final CsInsnDeallocator deallocator;

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public String getMnemonic() {
            return this.mnemonic;
        }

        @Override
        public String getOpStr() {
            return this.opStr;
        }

        @Override
        public short getSize() {
            return this.size;
        }

        @Override
        public OpInfo getOperands() {
            return this.operands;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        public CsInsn(_cs_insn insn, int _arch, Pointer _csh, CS _cs, boolean diet, CsInsnDeallocator deallocator) {
            this.id = insn.id;
            this.address = insn.address;
            this.size = insn.size;
            this.deallocator = deallocator;
            if (!diet) {
                int lm = 0;
                while (insn.mnemonic[lm++] != 0) {
                }
                int lo = 0;
                while (insn.op_str[lo++] != 0) {
                }
                this.mnemonic = new String(insn.mnemonic, 0, lm - 1);
                this.opStr = new String(insn.op_str, 0, lo - 1);
                this.bytes = Arrays.copyOf(insn.bytes, (int)insn.size);
            }
            this.cs = _cs;
            this.arch = _arch;
            this.raw = insn;
            this.csh = _csh;
            if (insn.cs_detail != null) {
                if (!diet) {
                    this.regsRead = new short[insn.cs_detail.regs_read_count];
                    System.arraycopy(insn.cs_detail.regs_read, 0, this.regsRead, 0, this.regsRead.length);
                    this.regsWrite = new short[insn.cs_detail.regs_write_count];
                    System.arraycopy(insn.cs_detail.regs_write, 0, this.regsWrite, 0, this.regsWrite.length);
                    this.groups = new byte[insn.cs_detail.groups_count];
                    System.arraycopy(insn.cs_detail.groups, 0, this.groups, 0, this.groups.length);
                }
                this.operands = this.getOptInfo(insn.cs_detail);
            }
        }

        private OpInfo getOptInfo(_cs_detail detail) {
            OpInfo op_info = null;
            switch (this.arch) {
                case 0: {
                    detail.arch.setType(Arm.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Arm.OpInfo(detail.arch.arm);
                    break;
                }
                case 1: {
                    detail.arch.setType(Arm64.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Arm64.OpInfo(detail.arch.arm64);
                    break;
                }
                case 2: {
                    detail.arch.setType(Mips.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Mips.OpInfo(detail.arch.mips);
                    break;
                }
                case 3: {
                    detail.arch.setType(X86.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new X86.OpInfo(detail.arch.x86);
                    break;
                }
                case 5: {
                    detail.arch.setType(Sparc.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Sparc.OpInfo(detail.arch.sparc);
                    break;
                }
                case 6: {
                    detail.arch.setType(Systemz.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Systemz.OpInfo(detail.arch.sysz);
                    break;
                }
                case 4: {
                    detail.arch.setType(Ppc.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Ppc.OpInfo(detail.arch.ppc);
                    break;
                }
                case 7: {
                    detail.arch.setType(Xcore.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new Xcore.OpInfo(detail.arch.xcore);
                    break;
                }
                case 10: {
                    detail.arch.setType(M680x.UnionOpInfo.class);
                    detail.arch.read();
                    op_info = new M680x.OpInfo(detail.arch.m680x);
                    break;
                }
            }
            return op_info;
        }

        public int opCount(int type) {
            return this.cs.cs_op_count(this.csh, this.raw.getPointer(), type);
        }

        public int opIndex(int type, int index) {
            return this.cs.cs_op_index(this.csh, this.raw.getPointer(), type, index);
        }

        public boolean regRead(int reg_id) {
            return this.cs.cs_reg_read(this.csh, this.raw.getPointer(), reg_id) != 0;
        }

        public boolean regWrite(int reg_id) {
            return this.cs.cs_reg_write(this.csh, this.raw.getPointer(), reg_id) != 0;
        }

        public int errno() {
            return this.cs.cs_errno(this.csh);
        }

        @Override
        public String regName(int reg_id) {
            return this.cs.cs_reg_name(this.csh, reg_id);
        }

        @Override
        public int mapToUnicornReg(int capstoneReg) {
            return capstoneReg;
        }

        @Override
        public int mapToCapstoneReg(int unicornReg) {
            return unicornReg;
        }

        public String insnName() {
            return this.cs.cs_insn_name(this.csh, this.id);
        }

        public String groupName(int id) {
            return this.cs.cs_group_name(this.csh, id);
        }

        public boolean group(int gid) {
            return this.cs.cs_insn_group(this.csh, this.raw.getPointer(), gid) != 0;
        }

        @Override
        public CsRegsAccess regsAccess() {
            Memory regsReadMemory = new Memory(128L);
            ByteByReference regsReadCountRef = new ByteByReference();
            Memory regsWriteMemory = new Memory(128L);
            ByteByReference regsWriteCountRef = new ByteByReference();
            int c = this.cs.cs_regs_access(this.csh, this.raw.getPointer(), (Pointer)regsReadMemory, regsReadCountRef, (Pointer)regsWriteMemory, regsWriteCountRef);
            if (c != 0) {
                return null;
            }
            byte regsReadCount = regsReadCountRef.getValue();
            byte regsWriteCount = regsWriteCountRef.getValue();
            short[] regsRead = new short[regsReadCount];
            regsReadMemory.read(0L, regsRead, 0, (int)regsReadCount);
            short[] regsWrite = new short[regsWriteCount];
            regsWriteMemory.read(0L, regsWrite, 0, (int)regsWriteCount);
            return new CsRegsAccess(regsRead, regsWrite);
        }
    }

    protected static class _cs_detail
    extends Structure {
        public short[] regs_read = new short[12];
        public byte regs_read_count;
        public short[] regs_write = new short[20];
        public byte regs_write_count;
        public byte[] groups = new byte[8];
        public byte groups_count;
        public UnionArch arch;

        protected _cs_detail() {
        }

        public List<String> getFieldOrder() {
            return Arrays.asList("regs_read", "regs_read_count", "regs_write", "regs_write_count", "groups", "groups_count", "arch");
        }

        public static class ByReference
        extends _cs_detail
        implements Structure.ByReference {
        }
    }

    protected static class _cs_insn
    extends Structure {
        public int id;
        public long address;
        public short size;
        public byte[] bytes = new byte[16];
        public byte[] mnemonic = new byte[32];
        public byte[] op_str = new byte[160];
        public _cs_detail.ByReference cs_detail;

        public _cs_insn() {
            Arrays.fill(this.mnemonic, (byte)0);
            Arrays.fill(this.op_str, (byte)0);
        }

        public _cs_insn(Pointer p) {
            this();
            this.useMemory(p);
            this.read();
        }

        public List<String> getFieldOrder() {
            return Arrays.asList("id", "address", "size", "bytes", "mnemonic", "op_str", "cs_detail");
        }
    }

    public static class UnionArch
    extends Union {
        public Arm.UnionOpInfo arm;
        public Arm64.UnionOpInfo arm64;
        public X86.UnionOpInfo x86;
        public Mips.UnionOpInfo mips;
        public Ppc.UnionOpInfo ppc;
        public Sparc.UnionOpInfo sparc;
        public Systemz.UnionOpInfo sysz;
        public Xcore.UnionOpInfo xcore;
        public M680x.UnionOpInfo m680x;

        public static class ByValue
        extends UnionArch
        implements Structure.ByValue {
        }
    }

    protected static abstract class UnionOpInfo
    extends Structure {
        protected UnionOpInfo() {
        }
    }

    public static interface OpInfo {
    }
}

