/*
 * Decompiled with CFR 0.152.
 */
package unicorn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.scijava.nativelib.NativeLoader;
import unicorn.Arm64Const;
import unicorn.ArmConst;
import unicorn.BlockHook;
import unicorn.CodeHook;
import unicorn.DebugHook;
import unicorn.EventMemHook;
import unicorn.Hook;
import unicorn.InHook;
import unicorn.InterruptHook;
import unicorn.M68kConst;
import unicorn.MemHook;
import unicorn.MemRegion;
import unicorn.MipsConst;
import unicorn.OutHook;
import unicorn.ReadHook;
import unicorn.SparcConst;
import unicorn.SyscallHook;
import unicorn.UnicornConst;
import unicorn.UnicornException;
import unicorn.WriteHook;
import unicorn.X86Const;
import unicorn.X86_MMR;

public class Unicorn
implements UnicornConst,
ArmConst,
Arm64Const,
M68kConst,
SparcConst,
MipsConst,
X86Const {
    private final long eng;
    private final int arch;
    private final int mode;
    private long blockHandle = 0L;
    private long interruptHandle = 0L;
    private long codeHandle = 0L;
    private final Hashtable<Integer, Long> eventMemHandles = new Hashtable();
    private final long readInvalidHandle = 0L;
    private final long writeInvalidHandle = 0L;
    private final long fetchProtHandle = 0L;
    private final long readProtHandle = 0L;
    private final long writeProtHandle = 0L;
    private long readHandle = 0L;
    private long writeHandle = 0L;
    private long inHandle = 0L;
    private long outHandle = 0L;
    private long syscallHandle = 0L;
    private final List<UnHook> newHookList = new ArrayList<UnHook>();
    private final ArrayList<Tuple> blockList = new ArrayList();
    private final ArrayList<Tuple> intrList = new ArrayList();
    private final ArrayList<Tuple> codeList = new ArrayList();
    private final ArrayList<Tuple> readList = new ArrayList();
    private final ArrayList<Tuple> writeList = new ArrayList();
    private final ArrayList<Tuple> inList = new ArrayList();
    private final ArrayList<Tuple> outList = new ArrayList();
    private final ArrayList<Tuple> syscallList = new ArrayList();
    private final Hashtable<Integer, ArrayList<Tuple>> eventMemLists = new Hashtable();
    private final ArrayList<ArrayList<Tuple>> allLists = new ArrayList();
    private static final Hashtable<Integer, Integer> eventMemMap = new Hashtable();
    private static final Hashtable<Long, Unicorn> unicorns = new Hashtable();

    private static void invokeBlockCallbacks(long eng, long address, int size) {
        Unicorn u = unicorns.get(eng);
        if (u != null) {
            for (Tuple p : u.blockList) {
                BlockHook bh = (BlockHook)p.function;
                bh.hook(u, address, size, p.data);
            }
        }
    }

    private static void invokeInterruptCallbacks(long eng, int intno) {
        Unicorn u = unicorns.get(eng);
        if (u != null) {
            for (Tuple p : u.intrList) {
                InterruptHook ih = (InterruptHook)p.function;
                ih.hook(u, intno, p.data);
            }
        }
    }

    private static void invokeCodeCallbacks(long eng, long address, int size) {
        Unicorn u = unicorns.get(eng);
        if (u != null) {
            for (Tuple p : u.codeList) {
                CodeHook ch = (CodeHook)p.function;
                ch.hook(u, address, size, p.data);
            }
        }
    }

    private static boolean invokeEventMemCallbacks(long eng, int type, long address, int size, long value) {
        ArrayList<Tuple> funcList;
        Unicorn u = unicorns.get(eng);
        boolean result = true;
        if (u != null && (funcList = u.eventMemLists.get(type)) != null) {
            for (Tuple p : funcList) {
                EventMemHook emh = (EventMemHook)p.function;
                result &= emh.hook(u, address, size, value, p.data);
            }
        }
        return result;
    }

    private static void invokeReadCallbacks(long eng, long address, int size) {
        Unicorn u = unicorns.get(eng);
        if (u != null) {
            for (Tuple p : u.readList) {
                ReadHook rh = (ReadHook)p.function;
                rh.hook(u, address, size, p.data);
            }
        }
    }

    private static void invokeWriteCallbacks(long eng, long address, int size, long value) {
        Unicorn u = unicorns.get(eng);
        if (u != null) {
            for (Tuple p : u.writeList) {
                WriteHook wh = (WriteHook)p.function;
                wh.hook(u, address, size, value, p.data);
            }
        }
    }

    private static int invokeInCallbacks(long eng, int port, int size) {
        Unicorn u = unicorns.get(eng);
        int result = 0;
        if (u != null) {
            for (Tuple p : u.inList) {
                InHook ih = (InHook)p.function;
                result = ih.hook(u, port, size, p.data);
            }
        }
        return result;
    }

    private static void invokeOutCallbacks(long eng, int port, int size, int value) {
        Unicorn u = unicorns.get(eng);
        boolean result = false;
        if (u != null) {
            for (Tuple p : u.outList) {
                OutHook oh = (OutHook)p.function;
                oh.hook(u, port, size, value, p.data);
            }
        }
    }

    private static void invokeSyscallCallbacks(long eng) {
        Unicorn u = unicorns.get(eng);
        boolean result = false;
        if (u != null) {
            for (Tuple p : u.syscallList) {
                SyscallHook sh = (SyscallHook)p.function;
                sh.hook(u, p.data);
            }
        }
    }

    private native void reg_write_num(int var1, Number var2) throws UnicornException;

    private native void reg_write_mmr(int var1, X86_MMR var2) throws UnicornException;

    private native Number reg_read_num(int var1) throws UnicornException;

    private native Number reg_read_mmr(int var1) throws UnicornException;

    private native long open(int var1, int var2) throws UnicornException;

    public Unicorn(int arch, int mode) throws UnicornException {
        this.arch = arch;
        this.mode = mode;
        this.eng = this.open(arch, mode);
        unicorns.put(this.eng, this);
        this.allLists.add(this.blockList);
        this.allLists.add(this.intrList);
        this.allLists.add(this.codeList);
        this.allLists.add(this.readList);
        this.allLists.add(this.writeList);
        this.allLists.add(this.inList);
        this.allLists.add(this.outList);
        this.allLists.add(this.syscallList);
    }

    protected void finalize() {
    }

    public static native int version();

    public static native boolean arch_supported(int var0);

    public void closeAll() throws UnicornException {
        for (UnHook unHook : this.newHookList) {
            unHook.unhookInternal();
        }
        this.close();
    }

    private native void close() throws UnicornException;

    public native int query(int var1) throws UnicornException;

    public native int errno();

    public static native String strerror(int var0);

    @Deprecated
    public native void reg_write(int var1, byte[] var2) throws UnicornException;

    public void reg_write(int regid, Object value) throws UnicornException {
        if (value instanceof Number) {
            this.reg_write_num(regid, (Number)value);
        } else if (this.arch == 4 && value instanceof X86_MMR) {
            if (regid >= 242 && regid <= 245) {
                this.reg_write_mmr(regid, (X86_MMR)value);
            }
        } else {
            throw new ClassCastException("Invalid value type");
        }
    }

    @Deprecated
    public native byte[] reg_read(int var1, int var2) throws UnicornException;

    public Object reg_read(int regid) throws UnicornException {
        if (this.arch == 4 && regid >= 242 && regid <= 245) {
            return this.reg_read_mmr(regid);
        }
        return this.reg_read_num(regid);
    }

    public void reg_write_batch(int[] regids, Object[] vals) throws UnicornException {
        if (regids.length != vals.length) {
            throw new UnicornException(Unicorn.strerror(15));
        }
        for (int i = 0; i < regids.length; ++i) {
            this.reg_write(regids[i], vals[i]);
        }
    }

    public Object[] reg_read_batch(int[] regids) throws UnicornException {
        Object[] vals = new Object[regids.length];
        for (int i = 0; i < regids.length; ++i) {
            vals[i] = this.reg_read(regids[i]);
        }
        return vals;
    }

    public native void mem_write(long var1, byte[] var3) throws UnicornException;

    public native byte[] mem_read(long var1, long var3) throws UnicornException;

    public native void emu_start(long var1, long var3, long var5, long var7) throws UnicornException;

    public native void emu_stop() throws UnicornException;

    private static native long registerHook(long var0, int var2);

    private static native long registerHook(long var0, int var2, NewHook var3);

    private static native long registerHook(long var0, int var2, int var3);

    private static native long registerHook(long var0, int var2, long var3, long var5);

    private static native long registerHook(long var0, int var2, long var3, long var5, NewHook var7);

    private static native long registerDebugger(long var0, long var2, long var4, NewHook var6);

    public native void setFastDebug(boolean var1);

    public native void setSingleStep(int var1);

    public native void addBreakPoint(long var1);

    public native void removeBreakPoint(long var1);

    private native void hook_del(long var1) throws UnicornException;

    public void hook_add(BlockHook callback, long begin, long end, Object user_data) throws UnicornException {
        if (this.blockHandle == 0L) {
            this.blockHandle = Unicorn.registerHook(this.eng, 8, begin, end);
        }
        this.blockList.add(new Tuple(callback, user_data));
    }

    public UnHook hook_add_new(BlockHook callback, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerHook(this.eng, 8, begin, end, hook);
        return new UnHook(handle);
    }

    public void hook_add(InterruptHook callback, Object user_data) throws UnicornException {
        if (this.interruptHandle == 0L) {
            this.interruptHandle = Unicorn.registerHook(this.eng, 1);
        }
        this.intrList.add(new Tuple(callback, user_data));
    }

    public UnHook hook_add_new(InterruptHook callback, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerHook(this.eng, 1, hook);
        return new UnHook(handle);
    }

    public void hook_add(CodeHook callback, long begin, long end, Object user_data) throws UnicornException {
        if (this.codeHandle == 0L) {
            this.codeHandle = Unicorn.registerHook(this.eng, 4, begin, end);
        }
        this.codeList.add(new Tuple(callback, user_data));
    }

    public UnHook hook_add_new(CodeHook callback, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerHook(this.eng, 4, begin, end, hook);
        return new UnHook(handle);
    }

    public UnHook debugger_add(DebugHook callback, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerDebugger(this.eng, begin, end, hook);
        return new UnHook(handle);
    }

    public void hook_add(ReadHook callback, long begin, long end, Object user_data) throws UnicornException {
        if (this.readHandle == 0L) {
            this.readHandle = Unicorn.registerHook(this.eng, 1024, begin, end);
        }
        this.readList.add(new Tuple(callback, user_data));
    }

    public UnHook hook_add_new(ReadHook callback, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerHook(this.eng, 1024, begin, end, hook);
        return new UnHook(handle);
    }

    public void hook_add(WriteHook callback, long begin, long end, Object user_data) throws UnicornException {
        if (this.writeHandle == 0L) {
            this.writeHandle = Unicorn.registerHook(this.eng, 2048, begin, end);
        }
        this.writeList.add(new Tuple(callback, user_data));
    }

    public UnHook hook_add_new(WriteHook callback, long begin, long end, Object user_data) throws UnicornException {
        NewHook hook = new NewHook(callback, user_data);
        long handle = Unicorn.registerHook(this.eng, 2048, begin, end, hook);
        return new UnHook(handle);
    }

    public void hook_add(MemHook callback, long begin, long end, Object user_data) throws UnicornException {
        this.hook_add((ReadHook)callback, begin, end, user_data);
        this.hook_add((WriteHook)callback, begin, end, user_data);
    }

    public void hook_add(EventMemHook callback, int type, Object user_data) throws UnicornException {
        for (Integer htype : eventMemMap.keySet()) {
            int cbType;
            ArrayList<Tuple> flist;
            if ((type & htype) == 0) continue;
            Long handle = this.eventMemHandles.get(htype);
            if (handle == null) {
                this.eventMemHandles.put(htype, Unicorn.registerHook(this.eng, htype));
            }
            if ((flist = this.eventMemLists.get(cbType = eventMemMap.get(htype).intValue())) == null) {
                flist = new ArrayList();
                this.allLists.add(flist);
                this.eventMemLists.put(cbType, flist);
            }
            flist.add(new Tuple(callback, user_data));
        }
    }

    public Map<Integer, UnHook> hook_add_new(EventMemHook callback, int type, Object user_data) throws UnicornException {
        HashMap<Integer, UnHook> map = new HashMap<Integer, UnHook>(eventMemMap.size());
        for (Integer htype : eventMemMap.keySet()) {
            if ((type & htype) == 0) continue;
            NewHook hook = new NewHook(callback, user_data);
            long handle = Unicorn.registerHook(this.eng, (int)htype, hook);
            map.put(htype, new UnHook(handle));
        }
        return map;
    }

    public void hook_add(InHook callback, Object user_data) throws UnicornException {
        if (this.inHandle == 0L) {
            this.inHandle = Unicorn.registerHook(this.eng, 2, 218);
        }
        this.inList.add(new Tuple(callback, user_data));
    }

    public void hook_add(OutHook callback, Object user_data) throws UnicornException {
        if (this.outHandle == 0L) {
            this.outHandle = Unicorn.registerHook(this.eng, 2, 500);
        }
        this.outList.add(new Tuple(callback, user_data));
    }

    public void hook_add(SyscallHook callback, Object user_data) throws UnicornException {
        if (this.syscallHandle == 0L) {
            this.syscallHandle = Unicorn.registerHook(this.eng, 2, 699);
        }
        this.syscallList.add(new Tuple(callback, user_data));
    }

    public void hook_del(Hook hook) throws UnicornException {
        for (ArrayList<Tuple> l : this.allLists) {
            for (Tuple t : l) {
                if (!t.function.equals(hook)) continue;
                this.allLists.remove(t);
                return;
            }
        }
    }

    public native void mem_map(long var1, long var3, int var5) throws UnicornException;

    public native void mem_map_ptr(long var1, long var3, int var5, byte[] var6) throws UnicornException;

    public native void mem_unmap(long var1, long var3) throws UnicornException;

    public native void mem_protect(long var1, long var3, int var5) throws UnicornException;

    public native MemRegion[] mem_regions() throws UnicornException;

    public native long context_alloc();

    public native void free(long var1);

    public native void context_save(long var1);

    public native void context_restore(long var1);

    static {
        try {
            NativeLoader.loadLibrary((String)"unicorn_java", (String[])new String[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        eventMemMap.put(16, 19);
        eventMemMap.put(32, 20);
        eventMemMap.put(64, 21);
        eventMemMap.put(128, 23);
        eventMemMap.put(256, 22);
        eventMemMap.put(512, 24);
        eventMemMap.put(1024, 16);
        eventMemMap.put(2048, 17);
        eventMemMap.put(4096, 18);
        eventMemMap.put(8192, 25);
    }

    private class NewHook
    extends Tuple {
        public NewHook(Hook f, Object d) {
            super(f, d);
        }

        void onBlock(long address, int size) {
            BlockHook hook = (BlockHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onCode(long address, int size) {
            CodeHook hook = (CodeHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onBreak(long address, int size) {
            DebugHook hook = (DebugHook)this.function;
            hook.onBreak(Unicorn.this, address, size, this.data);
        }

        void onRead(long address, int size) {
            ReadHook hook = (ReadHook)this.function;
            hook.hook(Unicorn.this, address, size, this.data);
        }

        void onWrite(long address, int size, long value) {
            WriteHook hook = (WriteHook)this.function;
            hook.hook(Unicorn.this, address, size, value, this.data);
        }

        void onInterrupt(int intno) {
            InterruptHook hook = (InterruptHook)this.function;
            hook.hook(Unicorn.this, intno, this.data);
        }

        boolean onMemEvent(int type, long address, int size, long value) {
            EventMemHook hook = (EventMemHook)this.function;
            return hook.hook(Unicorn.this, address, size, value, this.data);
        }
    }

    public class UnHook {
        private final long handle;
        private boolean unhooked;

        public UnHook(long handle) {
            this.handle = handle;
            Unicorn.this.newHookList.add(this);
        }

        public void unhook() {
            this.unhookInternal();
            Unicorn.this.newHookList.remove(this);
        }

        private void unhookInternal() {
            if (!this.unhooked) {
                Unicorn.this.hook_del(this.handle);
            }
            this.unhooked = true;
        }
    }

    private static class Tuple {
        public Hook function;
        public Object data;

        public Tuple(Hook f, Object d) {
            this.function = f;
            this.data = d;
        }
    }
}

