/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.ScaleFactor;

public abstract class LinearQuantity
extends Number
implements IQuantity {
    private static final long serialVersionUID = 1L;
    protected final LinearUnit unit;

    protected LinearQuantity(LinearUnit unit) {
        this.unit = unit;
    }

    public LinearUnit getUnit() {
        return this.unit;
    }

    @Override
    public int compareTo(IQuantity other) {
        if (other instanceof LinearQuantity) {
            try {
                return Double.compare(this.doubleValue(), ((LinearQuantity)other).doubleValueIn(this.unit));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.unit.getContentType().getIdentifier().compareTo(other.getUnit().getContentType().getIdentifier());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public long longValueIn(IUnit<?> targetUnit, long maxAbsValue) throws QuantityConversionException {
        if (targetUnit instanceof LinearUnit) {
            return this.longValueIn((LinearUnit)targetUnit, maxAbsValue);
        }
        throw new IllegalArgumentException("Cannot convert " + this.persistableString() + " into unit " + targetUnit);
    }

    public abstract long longValueIn(LinearUnit var1, long var2) throws QuantityConversionException;

    @Override
    public double doubleValueIn(IUnit<?> targetUnit) {
        if (targetUnit instanceof LinearUnit) {
            return this.doubleValueIn((LinearUnit)targetUnit);
        }
        throw new IllegalArgumentException("Cannot convert " + this.persistableString() + " into unit " + targetUnit);
    }

    public abstract double doubleValueIn(LinearUnit var1);

    @Override
    public final String interactiveFormat() {
        return this.localizedFormat(true, false);
    }

    public final String interactiveFormat(boolean allowCustomUnit) {
        return this.localizedFormat(true, allowCustomUnit);
    }

    protected abstract String localizedFormat(boolean var1, boolean var2);

    @Override
    public String displayUsing(String formatIdentifier) {
        return this.unit.getContentType().getDisplayUnit(formatIdentifier).format(this);
    }

    public String toString() {
        return this.persistableString();
    }

    public static class DoubleStored
    extends LinearQuantity {
        private static final long serialVersionUID = 1L;
        private final double numericalValue;

        public DoubleStored(double numericalValue, LinearUnit unit) {
            super(unit);
            this.numericalValue = numericalValue;
        }

        @Override
        public int intValue() {
            return (int)this.numericalValue;
        }

        @Override
        public long longValue() {
            return (long)this.numericalValue;
        }

        @Override
        public float floatValue() {
            return (float)this.numericalValue;
        }

        @Override
        public double doubleValue() {
            return this.numericalValue;
        }

        @Override
        public LinearQuantity in(IUnit<?> targetUnit) {
            LinearUnit linearUnit = (LinearUnit)targetUnit;
            return linearUnit.quantity(this.doubleValueIn(linearUnit));
        }

        @Override
        public long longValueIn(LinearUnit targetUnit, long maxAbsValue) throws QuantityConversionException {
            ScaleFactor factor = this.unit.valueFactorTo(targetUnit);
            if (factor.targetOutOfRange(this.numericalValue, maxAbsValue)) {
                if (this.numericalValue < 0.0) {
                    throw QuantityConversionException.tooLow(this, targetUnit.quantity(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL));
                }
                throw QuantityConversionException.tooHigh(this, targetUnit.quantity(maxAbsValue));
            }
            return (long)factor.targetValue(this.numericalValue);
        }

        @Override
        public double doubleValueIn(LinearUnit targetUnit) {
            return this.unit.valueFactorTo(targetUnit).targetValue(this.numericalValue);
        }

        @Override
        public String persistableString() {
            return this.unit.persistableStringFor(this.numericalValue);
        }

        @Override
        protected String localizedFormat(boolean useBreakingSpace, boolean allowCustomUnit) {
            return this.unit.localizedFormatFor(this.numericalValue, useBreakingSpace, allowCustomUnit);
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToLongBits(this.numericalValue);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DoubleStored) {
                DoubleStored otherQuantity = (DoubleStored)other;
                return this.numericalValue == otherQuantity.numericalValue && this.unit.equals(otherQuantity.unit);
            }
            return false;
        }
    }

    public static class LongStored
    extends LinearQuantity {
        private static final long serialVersionUID = 1L;
        private final long numericalValue;

        public LongStored(long numericalValue, LinearUnit unit) {
            super(unit);
            this.numericalValue = numericalValue;
        }

        @Override
        public int intValue() {
            return (int)this.numericalValue;
        }

        @Override
        public long longValue() {
            return this.numericalValue;
        }

        @Override
        public float floatValue() {
            return this.numericalValue;
        }

        @Override
        public double doubleValue() {
            return this.numericalValue;
        }

        @Override
        public LinearQuantity in(IUnit<?> targetUnit) {
            LinearUnit linearUnit = (LinearUnit)targetUnit;
            return linearUnit.quantity(this.doubleValueIn(linearUnit));
        }

        @Override
        public long longValueIn(LinearUnit targetUnit, long maxAbsValue) throws QuantityConversionException {
            ScaleFactor factor = this.unit.valueFactorTo(targetUnit);
            if (factor.targetOutOfRange(this.numericalValue, maxAbsValue)) {
                if (this.numericalValue < 0L) {
                    throw QuantityConversionException.tooLow(this, targetUnit.quantity(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL));
                }
                throw QuantityConversionException.tooHigh(this, targetUnit.quantity(maxAbsValue));
            }
            return factor.targetValue(this.numericalValue);
        }

        @Override
        public double doubleValueIn(LinearUnit targetUnit) {
            return this.unit.valueFactorTo(targetUnit).targetValue((double)this.numericalValue);
        }

        @Override
        public String persistableString() {
            return this.unit.persistableStringFor(this.numericalValue);
        }

        @Override
        protected String localizedFormat(boolean useBreakingSpace, boolean allowCustomUnit) {
            return this.unit.localizedFormatFor(this.numericalValue, useBreakingSpace, allowCustomUnit);
        }

        @Override
        public int hashCode() {
            return (int)this.numericalValue;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LongStored) {
                LongStored otherQuantity = (LongStored)other;
                return this.numericalValue == otherQuantity.numericalValue && this.unit.equals(otherQuantity.unit);
            }
            return false;
        }
    }
}

