/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.export.CSVExporter;
import org.netbeans.modules.profiler.snaptracer.impl.export.ExportBatch;
import org.netbeans.modules.profiler.snaptracer.impl.export.HTMLExporter;
import org.netbeans.modules.profiler.snaptracer.impl.export.XMLExporter;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VerticalLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.windows.WindowManager;

public final class DataExport {
    private static final Logger LOGGER = Logger.getLogger(DataExport.class.getName());
    private static final int INDETERMINATE_PROGRESS_THRESHOLD = Integer.getInteger("visualvm.tracer.indeterminateProgressThreshold", 2500);
    private static final Filter CSV_FILTER = Filter.create("CSV Files", ".csv");
    private static final Filter HTML_FILTER = Filter.create("HTML Files", ".html");
    private static final Filter XML_FILTER = Filter.create("XML Files", ".xml");
    private static JFileChooser fileChooser;
    private static File lastDirectory;
    private static Filter lastFilter;

    public static void exportData(final TableModel tableModel, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = DataExport.getFileChooser();
                if (jFileChooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated()) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Filter filter = (Filter)jFileChooser.getFileFilter();
                    DataExport.doExportData(tableModel, string, file, filter);
                }
                lastDirectory = jFileChooser.getCurrentDirectory();
                lastFilter = (Filter)jFileChooser.getFileFilter();
            }
        });
    }

    private static void doExportData(final TableModel tableModel, final String string, final File file, final Filter filter) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Writer writer = null;
                TracerProgressObject tracerProgressObject = null;
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    ExportBatch exportBatch = null;
                    if (filter == XML_FILTER) {
                        exportBatch = new XMLExporter().createBatch(tableModel, string, writer);
                    } else if (filter == HTML_FILTER) {
                        exportBatch = new HTMLExporter().createBatch(tableModel, string, writer);
                    } else if (filter == CSV_FILTER) {
                        exportBatch = new CSVExporter().createBatch(tableModel, string, writer);
                    }
                    if (exportBatch != null) {
                        final TracerProgressObject tracerProgressObject2 = tracerProgressObject = exportBatch.getProgress();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DataExport.showProgressDialog(tracerProgressObject2);
                            }
                        });
                        exportBatch.getWorker().run();
                    }
                }
                catch (Throwable throwable) {
                    if (tracerProgressObject != null) {
                        tracerProgressObject.setText("Exporting data failed");
                        tracerProgressObject.finish();
                    }
                    LOGGER.log(Level.INFO, "Exporting data failed", throwable);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    private static void showProgressDialog(final TracerProgressObject tracerProgressObject) {
        final JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        final JProgressBar jProgressBar = new JProgressBar(0, tracerProgressObject.getSteps()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 300;
                dimension.height += 2;
                return dimension;
            }
        };
        jProgressBar.setBorder(BorderFactory.createEmptyBorder());
        final Timer timer = new Timer(INDETERMINATE_PROGRESS_THRESHOLD, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jProgressBar.setIndeterminate(true);
                timer.stop();
            }
        });
        final JButton jButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getWindowAncestor(this).setVisible(false);
            }
        };
        tracerProgressObject.addListener(new TracerProgressObject.Listener(){

            @Override
            public void progressChanged(int n, int n2, String string) {
                timer.stop();
                jProgressBar.setIndeterminate(false);
                jProgressBar.setValue(n2);
                jLabel.setText(string == null ? "" : string);
                if (!tracerProgressObject.isFinished()) {
                    timer.start();
                } else {
                    jButton.setText("Close");
                }
            }
        });
        jLabel.setText(tracerProgressObject.getText());
        jProgressBar.setValue(tracerProgressObject.getCurrentStep());
        jButton.setText(tracerProgressObject.isFinished() ? "Close" : "Cancel");
        JPanel jPanel = new JPanel(new VerticalLayout(false));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 15, 10));
        jPanel.add(jLabel);
        jPanel.add(jProgressBar);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, "Export Tracer Data", true, new Object[]{jButton}, (Object)jButton, 0, null, null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                DataExport.openDialog(dialog);
                tracerProgressObject.finish();
            }
        });
    }

    private static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = DataExport.createFileChooser();
        }
        if (lastDirectory != null) {
            fileChooser.setCurrentDirectory(lastDirectory);
        }
        if (lastFilter != null) {
            fileChooser.setFileFilter(lastFilter);
        }
        return fileChooser;
    }

    private static JFileChooser createFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                Filter filter = (Filter)this.getFileFilter();
                if (!file.getName().endsWith(filter.getExt())) {
                    file = new File(file.getPath() + filter.getExt());
                    this.setSelectedFile(file);
                }
                if (!file.isFile()) {
                    super.approveSelection();
                    return;
                }
                final boolean[] blArray = new boolean[1];
                JButton jButton = new JButton("Yes"){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        blArray[0] = true;
                        super.fireActionPerformed(actionEvent);
                    }
                };
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)("File \"" + file.getName() + "\" already exists.\n" + "Do you want to replace it?"), "Replace Existing File", true, new Object[]{jButton, new JButton("No")}, (Object)jButton, 0, null, null);
                dialogDescriptor.setMessageType(3);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                DataExport.openDialog(dialog);
                if (blArray[0]) {
                    super.approveSelection();
                }
            }
        };
        jFileChooser.setDialogTitle("Export Tracer Data");
        jFileChooser.setDialogType(1);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(CSV_FILTER);
        jFileChooser.addChoosableFileFilter(HTML_FILTER);
        jFileChooser.addChoosableFileFilter(XML_FILTER);
        return jFileChooser;
    }

    private static void openDialog(Dialog dialog) {
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).setLocationRelativeTo((Component)WindowManager.getDefault().getRegistry().getActivated());
        }
        dialog.setVisible(true);
    }

    private DataExport() {
    }

    static {
        lastFilter = CSV_FILTER;
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String string, final String string2) {
            return new Filter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || Filter.getFileExt(file.getName()).equals(string2);
                }

                @Override
                public String getExt() {
                    return string2;
                }

                @Override
                public String getDescription() {
                    return string + " (*" + string2 + ")";
                }
            };
        }

        private static String getFileExt(String string) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return "";
            }
            return string.substring(n);
        }

        private Filter() {
        }
    }
}

