/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.containers;

import com.jrockit.mc.components.ui.base.AbstractUIContainer;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class SashComponent
extends AbstractUIContainer {
    @Override
    public final Control createPart(Composite parent) {
        SashForm form = this.createSashForm(parent);
        GUIFactory factory = GUIFactory.createChildFactory(this.getServiceLocator());
        form.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        int[] weights = new int[this.getLayoutItem().getChildren().size()];
        int weightIndex = 0;
        for (LayoutItem sd : this.getLayoutItem().getChildren()) {
            float weight = this.createSash(factory, form, sd);
            if (!(weight >= 0.0f)) continue;
            weights[weightIndex++] = (int)(10.0f * weight);
        }
        form.setWeights(SashComponent.truncate(weights, weightIndex));
        return form;
    }

    protected abstract SashForm createSashForm(Composite var1);

    private static int[] truncate(int[] source, int newSize) {
        int[] destination = new int[newSize];
        System.arraycopy(source, 0, destination, 0, newSize);
        return destination;
    }

    private float createSash(GUIFactory factory, SashForm parent, LayoutItem sd) {
        ComponentHolder holder = factory.createDisposableComponent(sd, (Composite)parent);
        if (holder.component != null) {
            factory.addComponentToScope(holder.component);
        }
        return sd.getLayoutData().getWeight();
    }
}

