/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.internal.fields.AlmostThreadRootFrameField;
import com.jrockit.mc.flightrecorder.internal.fields.ClassPackageField;
import com.jrockit.mc.flightrecorder.internal.fields.JavaThreadIdField;
import com.jrockit.mc.flightrecorder.internal.fields.MethodClassField;
import com.jrockit.mc.flightrecorder.internal.fields.MethodPackageField;
import com.jrockit.mc.flightrecorder.internal.fields.OsThreadIdField;
import com.jrockit.mc.flightrecorder.internal.fields.TopFrameClassField;
import com.jrockit.mc.flightrecorder.internal.fields.TopFrameField;
import com.jrockit.mc.flightrecorder.internal.fields.TopFrameMethodField;
import com.jrockit.mc.flightrecorder.internal.fields.TopFramePackageField;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ParserFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Synthetics;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataType;
import com.jrockit.mc.flightrecorder.internal.parser.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.Transition;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.provider.DefaultFactories;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Producer;
import com.jrockit.mc.flightrecorder.spi.IEventFactory;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IFieldFactory;
import java.util.ArrayList;
import java.util.List;

public class EventParserBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventParser createEventParser(EventTypeDescriptor etd, Producer producer, ParserFactory parserFactory) {
        etd = Synthetics.modifyEventTypeDescriptor(etd);
        ValueDescriptor[] dataStructure = Synthetics.createTopDescriptors(etd, etd.getDataStructure());
        List<ValueField> valueFields = EventParserBuilder.createEventValueFields(dataStructure);
        int valueFieldCount = valueFields.size();
        IParser[] valueParsers = new IParser[valueFieldCount];
        int n = 0;
        while (n < valueFieldCount) {
            valueParsers[n] = parserFactory.createParser(valueFields.get((int)n).desc);
            ++n;
        }
        Producer producer2 = producer;
        synchronized (producer2) {
            boolean isNewEventType = !producer.hasEventType(etd.getIdentifier());
            EventType eventType = producer.createEventType(etd.getIdentifier());
            if (isNewEventType) {
                EventParserBuilder.initEventType(eventType, etd, valueFields, parserFactory);
            }
            IEventFactory eventFactory = DefaultFactories.createEventFactory(valueFieldCount);
            EventParser ep = new EventParser(eventType, eventFactory, valueParsers);
            ep.setEventHooks(Synthetics.getEventHooks(eventType.getPath()));
            return ep;
        }
    }

    private static void initEventType(EventType type, EventTypeDescriptor etd, List<ValueField> eventValueFields, ParserFactory parserFactory) {
        IFieldFactory fieldFactory = DefaultFactories.createFieldFactory(type, eventValueFields.size());
        int valueFieldIndex = 0;
        for (ValueField vf : eventValueFields) {
            String fieldId = vf.id;
            IField valueField = fieldFactory.createValueField(fieldId, etd.getPath(), vf.desc.getContentTypeString(), vf.name, vf.desc.getDescription(), vf.desc.getRelationalKey(), parserFactory.getFieldType(vf.desc), EventParserBuilder.getProperties(vf.desc));
            int contentType = vf.desc.getContentType();
            switch (contentType) {
                case 9: {
                    type.addField(new TopFrameField(type, fieldId, valueField));
                    type.addField(new TopFramePackageField(type, fieldId, valueField));
                    type.addField(new TopFrameClassField(type, fieldId, valueField));
                    type.addField(new TopFrameMethodField(type, fieldId, valueField));
                    type.addField(new AlmostThreadRootFrameField(type, fieldId, valueField));
                    break;
                }
                case 7: {
                    type.addField(new JavaThreadIdField(type, fieldId, valueField));
                    type.addField(new OsThreadIdField(type, fieldId, valueField));
                    break;
                }
                case 32: {
                    type.addField(new MethodClassField(type, fieldId, valueField));
                    type.addField(new MethodPackageField(type, fieldId, valueField));
                    break;
                }
                case 10: {
                    type.addField(new ClassPackageField(type, fieldId, valueField));
                }
            }
            if ("(thread)".equals(fieldId)) {
                type.setThreadValueIndex(valueFieldIndex);
            }
            ++valueFieldIndex;
        }
        type.setPath(etd.getPath());
        type.setHasStartTime(etd.hasStartTime());
        type.setColor(EventAppearance.getColor(etd.getPath()));
        type.setName(etd.getName());
        type.setDescription(etd.getDescription());
    }

    private static String[] getProperties(ValueDescriptor desc) {
        Transition transition = desc.getTransition();
        if (transition == Transition.To) {
            return new String[]{"transitionTo"};
        }
        if (transition == Transition.From) {
            return new String[]{"transitionFrom"};
        }
        return new String[0];
    }

    private static List<ValueField> createEventValueFields(ValueDescriptor[] dataStructure) {
        ArrayList<ValueField> valueFields = new ArrayList<ValueField>();
        EventParserBuilder.createEventValueFields(dataStructure, "", "", valueFields);
        return valueFields;
    }

    private static void createEventValueFields(ValueDescriptor[] dataStructure, String namePrefix, String identifierPrefix, List<ValueField> valueFields) {
        ValueDescriptor[] valueDescriptorArray = dataStructure;
        int n = dataStructure.length;
        int n2 = 0;
        while (n2 < n) {
            ValueDescriptor vd = valueDescriptorArray[n2];
            String name = EventParserBuilder.makeName(namePrefix, vd);
            String identifier = EventParserBuilder.makeIdentifier(identifierPrefix, vd);
            if (vd.getDataType() == DataType.STRUCT) {
                ValueDescriptor[] children = vd.getChildren();
                if (children.length == 1) {
                    EventParserBuilder.createEventValueFields(children, namePrefix, identifierPrefix, valueFields);
                } else {
                    EventParserBuilder.createEventValueFields(children, name, identifier, valueFields);
                }
            } else {
                valueFields.add(new ValueField(vd, name, identifier));
            }
            ++n2;
        }
    }

    private static String makeName(String namePrefix, ValueDescriptor desc) {
        return namePrefix.length() > 0 ? String.valueOf(namePrefix) + " : " + desc.getName() : desc.getName();
    }

    private static String makeIdentifier(String identifierPrefix, ValueDescriptor desc) {
        return identifierPrefix.length() > 0 ? String.valueOf(identifierPrefix) + ":" + desc.getIdentifier() : desc.getIdentifier();
    }

    private static class ValueField {
        ValueDescriptor desc;
        String name;
        String id;

        public ValueField(ValueDescriptor desc, String name, String id) {
            this.desc = desc;
            this.name = name;
            this.id = id;
        }
    }
}

